IF  EXISTS (SELECT *
FROM sys.objects
WHERE object_id = OBJECT_ID(N'[dbo].[EST_PED_VD_PAG_CREDIARIO]') AND type in (N'U'))
begin
	return;
end
else
begin
	CREATE TABLE [dbo].[EST_PED_VD_PAG_CREDIARIO]
	(
		[CD_EMP] [int] NOT NULL,
		[CD_FILIAL] [int] NOT NULL,
		[CD_PED] [int] NOT NULL,
		[CD_ORC_PAG] [int] NOT NULL,
		[CD_MDL_VD] [int] NOT NULL,
		[PARCELA] [int] NOT NULL,
		[VLR_PAG] [money] not null,
		CONSTRAINT [PK_EST_PED_VD_PAG_CREDIARIO] PRIMARY KEY CLUSTERED 
	(
		[CD_EMP] ASC,
		[CD_FILIAL] ASC,
		[CD_PED] ASC,
		[CD_ORC_PAG] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]



	ALTER TABLE [dbo].[EST_PED_VD_PAG_CREDIARIO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PED_VD_PAG_CREDIARIO_EST_PED_VD] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_PED])
	REFERENCES [dbo].[EST_PED_VD] ([CD_EMP], [CD_FILIAL], [CD_PED])


	ALTER TABLE [dbo].[EST_PED_VD_PAG_CREDIARIO] CHECK CONSTRAINT [FK_EST_PED_VD_PAG_CREDIARIO_EST_PED_VD]

end